/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import cc.tweaked.cobalt.internal.unwind.AutoUnwind;
import cc.tweaked.cobalt.internal.unwind.Pause;
import cc.tweaked.cobalt.internal.unwind.UnwindState;
import org.squiddev.cobalt.CachedMetamethod;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugState;
import org.squiddev.cobalt.function.Dispatch;
import org.squiddev.cobalt.function.LuaFunction;

public final class OperationHelper {
    private OperationHelper() {
    }

    public static LuaValue add(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(dLeft + dRight);
        }
        return OperationHelper.arithMetatable(state, Constants.ADD, left, right);
    }

    public static LuaValue sub(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(dLeft - dRight);
        }
        return OperationHelper.arithMetatable(state, Constants.SUB, left, right);
    }

    public static LuaValue mul(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft;
        if (left instanceof LuaInteger) {
            LuaInteger l = (LuaInteger)left;
            if (right instanceof LuaInteger) {
                LuaInteger r = (LuaInteger)right;
                return LuaInteger.valueOf((long)l.intValue() * (long)r.intValue());
            }
        }
        if (OperationHelper.checkNumber(left, dLeft = left.toDouble()) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(dLeft * dRight);
        }
        return OperationHelper.arithMetatable(state, Constants.MUL, left, right);
    }

    public static LuaValue div(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(OperationHelper.div(dLeft, dRight));
        }
        return OperationHelper.arithMetatable(state, Constants.DIV, left, right);
    }

    public static LuaValue mod(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(OperationHelper.mod(dLeft, dRight));
        }
        return OperationHelper.arithMetatable(state, Constants.MOD, left, right);
    }

    public static LuaValue pow(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(Math.pow(dLeft, dRight));
        }
        return OperationHelper.arithMetatable(state, Constants.POW, left, right);
    }

    public static double div(double lhs, double rhs) {
        return rhs != 0.0 ? lhs / rhs : (lhs > 0.0 ? Double.POSITIVE_INFINITY : (lhs == 0.0 ? Double.NaN : Double.NEGATIVE_INFINITY));
    }

    public static double mod(double lhs, double rhs) {
        double mod = lhs % rhs;
        return mod * rhs < 0.0 ? mod + rhs : mod;
    }

    private static LuaValue arithMetatable(LuaState state, LuaValue tag, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return Dispatch.call(state, OperationHelper.getMetatable(state, tag, left, right), left, right);
    }

    private static LuaValue getMetatable(LuaState state, LuaValue tag, LuaValue left, LuaValue right) throws LuaError {
        LuaValue h = left.metatag(state, tag);
        if (!h.isNil()) {
            return h;
        }
        h = right.metatag(state, tag);
        if (!h.isNil()) {
            return h;
        }
        throw OperationHelper.createArithmeticError(state, left, right);
    }

    private static LuaError createArithmeticError(LuaState state, LuaValue left, LuaValue right) {
        int stack;
        LuaValue value;
        int b = -1;
        int c = -1;
        DebugFrame frame = DebugState.get(state).getStack();
        if (frame != null && frame.closure != null) {
            Prototype prototype = frame.closure.getPrototype();
            if (frame.pc >= 0 && frame.pc <= prototype.code.length) {
                int i = prototype.code[frame.pc];
                assert (Lua.getOpMode(Lua.GET_OPCODE(i)) == 0 && Lua.getBMode(Lua.GET_OPCODE(i)) == 3 && Lua.getCMode(Lua.GET_OPCODE(i)) == 3) : Lua.getOpName(Lua.GET_OPCODE(i)) + " is not an iABC/RK/RX instruction";
                b = Lua.GETARG_B(i);
                c = Lua.GETARG_C(i);
            }
        }
        if (!left.isNumber()) {
            value = left;
            stack = b;
        } else {
            value = right;
            stack = c;
        }
        return ErrorFactory.operandError(state, value, "perform arithmetic on", stack);
    }

    public static LuaValue concatNonStrings(LuaState state, LuaValue left, LuaValue right, int leftStack, int rightStack) throws LuaError, UnwindThrowable {
        LuaValue h = left.metatag(state, Constants.CONCAT);
        if (h.isNil() && (h = right.metatag(state, Constants.CONCAT)).isNil()) {
            if (left.isString()) {
                throw ErrorFactory.operandError(state, right, "concatenate", rightStack);
            }
            throw ErrorFactory.operandError(state, left, "concatenate", leftStack);
        }
        return Dispatch.call(state, h, left, right);
    }

    private static LuaValue getComparisonMetatable(LuaState state, LuaValue tag, LuaValue left, LuaValue right) throws LuaError {
        LuaValue h = left.metatag(state, tag);
        if (!h.isNil()) {
            return h;
        }
        return right.metatag(state, tag);
    }

    public static boolean lt(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        int tLeft = left.type();
        int tRight = right.type();
        if (tLeft == 3 && tRight == 3) {
            return left.toDouble() < right.toDouble();
        }
        if (tLeft == 4 && tRight == 4) {
            return left.checkLuaString().compareTo(right.checkLuaString()) < 0;
        }
        LuaValue mt = OperationHelper.getComparisonMetatable(state, Constants.LT, left, right);
        if (mt.isNil()) {
            throw ErrorFactory.compareError(left, right);
        }
        return Dispatch.call(state, mt, left, right).toBoolean();
    }

    public static boolean le(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        int tLeft = left.type();
        int tRight = right.type();
        if (tLeft == 3 && tRight == 3) {
            return left.toDouble() <= right.toDouble();
        }
        if (tLeft == 4 && tRight == 4) {
            return left.checkLuaString().compareTo(right.checkLuaString()) <= 0;
        }
        LuaValue leMt = OperationHelper.getComparisonMetatable(state, Constants.LE, left, right);
        if (!leMt.isNil()) {
            return Dispatch.call(state, leMt, left, right).toBoolean();
        }
        LuaValue ltMt = OperationHelper.getComparisonMetatable(state, Constants.LT, left, right);
        if (ltMt.isNil()) {
            throw ErrorFactory.compareError(left, right);
        }
        DebugFrame frame = DebugState.get(state).getStackUnsafe();
        frame.flags |= 0x20;
        boolean result = !Dispatch.call(state, ltMt, right, left).toBoolean();
        frame.flags ^= 0x20;
        return result;
    }

    public static boolean eq(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        int tLeft = left.type();
        if (tLeft != right.type()) {
            return false;
        }
        return switch (tLeft) {
            case 0 -> true;
            case 3 -> {
                if (left.toDouble() == right.toDouble()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (left.toBoolean() == right.toBoolean()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (left == right || left.equals(right)) {
                    yield true;
                }
                yield false;
            }
            case 5, 7 -> {
                if (left == right || left.equals(right)) {
                    yield true;
                }
                LuaTable leftMeta = left.getMetatable(state);
                if (leftMeta == null) {
                    yield false;
                }
                LuaTable rightMeta = right.getMetatable(state);
                if (rightMeta == null) {
                    yield false;
                }
                LuaValue h = leftMeta.rawget(CachedMetamethod.EQ);
                if (!h.isNil() && h == rightMeta.rawget(CachedMetamethod.EQ) && Dispatch.call(state, h, left, right).toBoolean()) {
                    yield true;
                }
                yield false;
            }
            default -> left == right || left.equals(right);
        };
    }

    public static LuaValue length(LuaState state, LuaValue value) throws LuaError, UnwindThrowable {
        switch (value.type()) {
            case 5: {
                LuaValue h = value.metatag(state, CachedMetamethod.LEN);
                if (h.isNil()) {
                    return LuaInteger.valueOf(((LuaTable)value).length());
                }
                return Dispatch.call(state, h, value);
            }
            case 4: {
                return LuaInteger.valueOf(((LuaString)value).length());
            }
        }
        LuaValue h = value.metatag(state, CachedMetamethod.LEN);
        if (h.isNil()) {
            throw OperationHelper.createUnaryOpError(state, value, "get length of");
        }
        return Dispatch.call(state, h, value);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AutoUnwind
    public static int intLength(LuaState luaState, LuaValue luaValue, Object object) throws LuaError, Pause {
        int intValue;
        LuaValue length;
        LuaValue luaValue2;
        if (object == null) {
            void table;
            LuaState state;
            luaValue2 = OperationHelper.length(state, (LuaValue)table);
        } else {
            object = (UnwindState)object;
            if (((UnwindState)object).state != 0) {
                throw new IllegalStateException("Resuming into unknown state");
            }
            ((UnwindState)object).resumeArgs = null;
            luaValue2 = ((UnwindState)object).resumeArgs.first();
        }
        if ((length = luaValue2) instanceof LuaInteger) {
            LuaInteger i = (LuaInteger)length;
            return i.intValue();
        }
        double value = length.toDouble();
        if (value == (double)(intValue = (int)value)) {
            return intValue;
        }
        throw new LuaError("object length is not an integer");
        catch (UnwindThrowable unwindThrowable) {
            object = UnwindState.getOrCreate(object);
            ((UnwindState)object).state = 0;
            throw new Pause(unwindThrowable, (UnwindState)object);
        }
    }

    public static LuaValue neg(LuaState state, LuaValue value) throws LuaError, UnwindThrowable {
        double res;
        int type = value.type();
        if (type == 3) {
            int x;
            if (value instanceof LuaInteger && (x = ((LuaInteger)value).intValue()) != Integer.MIN_VALUE) {
                return LuaInteger.valueOf(-x);
            }
            return LuaDouble.valueOf(-value.toDouble());
        }
        if (type == 4 && !Double.isNaN(res = value.toDouble())) {
            return LuaDouble.valueOf(-res);
        }
        LuaValue meta = value.metatag(state, Constants.UNM);
        if (meta.isNil()) {
            throw OperationHelper.createUnaryOpError(state, value, "perform arithmetic on");
        }
        return Dispatch.call(state, meta, value);
    }

    private static boolean checkNumber(LuaValue lua, double value) {
        return lua.type() == 3 || !Double.isNaN(value);
    }

    private static LuaError createUnaryOpError(LuaState state, LuaValue value, String message) {
        int b = -1;
        DebugFrame frame = DebugState.get(state).getStack();
        if (frame != null && frame.closure != null) {
            Prototype prototype = frame.closure.getPrototype();
            if (frame.pc >= 0 && frame.pc <= prototype.code.length) {
                int i = prototype.code[frame.pc];
                assert (Lua.getOpMode(Lua.GET_OPCODE(i)) == 0 && Lua.getBMode(Lua.GET_OPCODE(i)) == 2) : Lua.getOpName(Lua.GET_OPCODE(i)) + " is not an iABC/RK instruction";
                b = Lua.GETARG_B(i);
            }
        }
        return ErrorFactory.operandError(state, value, message, b);
    }

    public static LuaValue getTable(LuaState state, LuaValue t, LuaValue key) throws LuaError, UnwindThrowable {
        return OperationHelper.getTable(state, t, key, -1);
    }

    public static LuaValue getTable(LuaState state, LuaValue t, int key) throws LuaError, UnwindThrowable {
        LuaTable table;
        LuaValue value;
        if (t instanceof LuaTable && !(value = (table = (LuaTable)t).rawget(key)).isNil()) {
            return value;
        }
        return OperationHelper.getTable(state, t, LuaInteger.valueOf(key));
    }

    public static LuaValue getTable(LuaState state, LuaValue t, LuaValue key, int stack) throws LuaError, UnwindThrowable {
        int loop = 0;
        do {
            LuaValue tm;
            if (t instanceof LuaTable) {
                LuaTable table = (LuaTable)t;
                LuaValue res = table.rawget(key);
                if (!res.isNil() || (tm = t.metatag(state, CachedMetamethod.INDEX)).isNil()) {
                    return res;
                }
            } else {
                tm = t.metatag(state, CachedMetamethod.INDEX);
                if (tm.isNil()) {
                    throw ErrorFactory.operandError(state, t, "index", stack);
                }
            }
            if (tm instanceof LuaFunction) {
                LuaFunction metaFunc = (LuaFunction)tm;
                return Dispatch.call(state, (LuaValue)metaFunc, t, key);
            }
            t = tm;
            stack = -1;
        } while (++loop < 100);
        throw new LuaError("loop in gettable");
    }

    public static void setTable(LuaState state, LuaValue t, LuaValue key, LuaValue value) throws LuaError, UnwindThrowable {
        OperationHelper.setTable(state, t, key, value, -1);
    }

    public static void setTable(LuaState state, LuaValue t, int key, LuaValue value) throws LuaError, UnwindThrowable {
        LuaTable table;
        if (t instanceof LuaTable && (table = (LuaTable)t).trySet(key, value)) {
            return;
        }
        OperationHelper.setTable(state, t, LuaInteger.valueOf(key), value);
    }

    public static void setTable(LuaState state, LuaValue t, LuaValue key, LuaValue value, int stack) throws LuaError, UnwindThrowable {
        int loop = 0;
        do {
            LuaTable table;
            if (t instanceof LuaTable && (table = (LuaTable)t).trySet(key, value)) {
                return;
            }
            LuaValue tm = t.metatag(state, CachedMetamethod.NEWINDEX);
            if (tm.isNil()) {
                throw ErrorFactory.operandError(state, t, "index", stack);
            }
            if (tm instanceof LuaFunction) {
                LuaFunction metaFunc = (LuaFunction)tm;
                Dispatch.call(state, (LuaValue)metaFunc, t, key, value);
                return;
            }
            t = tm;
            stack = -1;
        } while (++loop < 100);
        throw new LuaError("loop in settable");
    }

    public static LuaValue toString(LuaState state, LuaValue value) throws LuaError, UnwindThrowable {
        LuaValue h = value.metatag(state, Constants.TOSTRING);
        return h.isNil() ? OperationHelper.toStringDirect(value) : Dispatch.call(state, h, value);
    }

    public static LuaString checkToString(LuaValue value) throws LuaError {
        LuaValue asStr = value.toLuaString();
        if (asStr.isNil()) {
            throw new LuaError("'__tostring' must return a string");
        }
        return (LuaString)asStr;
    }

    public static LuaString toStringDirect(LuaValue value) {
        LuaValue v = value.toLuaString();
        return v.isNil() ? LuaString.valueOf(value.toString()) : (LuaString)v;
    }
}

